/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: CPY 10/14/2006														*
 * Purpose: OriginC Source C file												*
 * Copyright (c) Originlab Corp.	2006										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
#include <Origin.h>
#include <Operation.h>
#include "oEvents.h"
#include "OriginEvents.h"

/// YuI 12/07/04 v7.5172 PICTURE_IN_REPORT_IMPROVEMENT
class	OC_REGISTERED DataPlotDrawEvent	:	public	OriginEventsBase
{
public:
	/// YuI 08/15/06 MORE_WORK_ON_STATISTICAL_PLOTS
	//	virtual bool	OnDataPlotUpdatePercentileDataset(string& strOperationUID_GUID);
	virtual bool	OnDataPlotUpdateStatsTree(string& strOperationUID_GUID, TreeNode& trStats, BOOL& bUpdated);
	/// end MORE_WORK_ON_STATISTICAL_PLOTS
	
	virtual bool	OnGetTickLabel(string& strOperationUID_GUID, string& strLabel);
	virtual	bool 	SetObj(OriginObject &obj);
protected:
	UINT			GetOperationUID(string& strOperationUID_GUID);
	int				GetDataIndex(string& strOperationUID_GUID);
	
private:
	DataPlot		m_DataPlot;
};
/// end PICTURE_IN_REPORT_IMPROVEMENT


/// YuI 12/07/04 v7.5172 PICTURE_IN_REPORT_IMPROVEMENT
int		DataPlotDrawEvent::GetDataIndex(string& strOperationUID_GUID)
{
	string strIndex = strOperationUID_GUID.GetToken(2);
	int nIndex = atoi(strIndex);
	return nIndex;
}

UINT	DataPlotDrawEvent::GetOperationUID(string& strOperationUID_GUID)
{
	string strUID = strOperationUID_GUID.GetToken(0);
	string strGUID = strOperationUID_GUID.GetToken(1);
	string strDataIndex = strOperationUID_GUID.GetToken(2);
	
	int nUID = atoi(strUID);
	LPCSTR lpcszGUID = NULL;
	if( !strGUID.IsEmpty() )
		lpcszGUID = strGUID;

	OriginObject objTemp;
	objTemp = Project.GetObject(nUID, lpcszGUID);
	if( !objTemp )
		return 0;
	
	Operation& op = (Operation&)Project.GetOperationObject(nUID, lpcszGUID);
	if( op == NULL || !op.IsValid() )
		return 0;
	
	if( op.GetUID() != nUID )
	{
		strOperationUID_GUID = nUID;
		strOperationUID_GUID += " ";
		strOperationUID_GUID += lpcszGUID;
		strOperationUID_GUID += " " + strDataIndex;
	}
	
	return op.GetUID();
}

bool	DataPlotDrawEvent::OnGetTickLabel(string& strOperationUID_GUID, string& strLabel)
{
	Operation& op = (Operation&) Project.GetOperationObject(GetOperationUID(strOperationUID_GUID));
	if( op )
	{
		return op.GetTickLabel(m_DataPlot, GetDataIndex(strOperationUID_GUID), strLabel);
	}
}

/// YuI 08/15/06 MORE_WORK_ON_STATISTICAL_PLOTS
//	bool	DataPlotDrawEvent::OnDataPlotUpdatePercentileDataset(string& strOperationUID_GUID)
bool	DataPlotDrawEvent::OnDataPlotUpdateStatsTree(string& strOperationUID_GUID, TreeNode& trStats, BOOL& bUpdated)
/// end MORE_WORK_ON_STATISTICAL_PLOTS
{
	int nOperationUID = GetOperationUID(strOperationUID_GUID);
	if( nOperationUID == 0 )
		return false;
	
	Operation& op = (Operation&) Project.GetOperationObject(nOperationUID);
	if( op )
	{
		/// YuI 08/15/06 MORE_WORK_ON_STATISTICAL_PLOTS
		//	return op.UpdatePercentileDataset(m_DataPlot, GetDataIndex(strOperationUID_GUID));
		return op.UpdateStatsTree(trStats, GetDataIndex(strOperationUID_GUID), bUpdated);
		/// end MORE_WORK_ON_STATISTICAL_PLOTS
	}
	
	return false;
}

bool 	DataPlotDrawEvent::SetObj(OriginObject &obj)
{
	m_DataPlot = (DataPlot) obj;
	return true;
}
/// end PICTURE_IN_REPORT_IMPROVEMENT


